<?php
/**
 * volunteer post type
 *
 * @package    apus-charityheart
 * @author     ApusTheme <apusthemes@gmail.com >
 * @license    GNU General Public License, version 3
 * @copyright  13/06/2016 ApusTheme
 */
 
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
class ApusCharityheart_PostType_Give_Volunteer {

	/**
	 * init action and filter data to define resource post type
	 */
	public static function init() {
		add_action( 'init', array( __CLASS__, 'definition' ) );
		add_filter( 'cmb2_meta_boxes', array( __CLASS__, 'metaboxes' ) );
	}
	/**
	 *
	 */
	public static function definition() {
		
		$labels = array(
			'name'                  => __( 'Apus Volunteers', 'apus-charityheart' ),
			'singular_name'         => __( 'Volunteer', 'apus-charityheart' ),
			'add_new'               => __( 'Add New Volunteer', 'apus-charityheart' ),
			'add_new_item'          => __( 'Add New Volunteer', 'apus-charityheart' ),
			'edit_item'             => __( 'Edit Volunteer', 'apus-charityheart' ),
			'new_item'              => __( 'New Volunteer', 'apus-charityheart' ),
			'all_items'             => __( 'All Volunteers', 'apus-charityheart' ),
			'view_item'             => __( 'View Volunteer', 'apus-charityheart' ),
			'search_items'          => __( 'Search Volunteer', 'apus-charityheart' ),
			'not_found'             => __( 'No Volunteers found', 'apus-charityheart' ),
			'not_found_in_trash'    => __( 'No Volunteers found in Trash', 'apus-charityheart' ),
			'parent_item_colon'     => '',
			'menu_name'             => __( 'Apus Volunteers', 'apus-charityheart' ),
		);

		$labels = apply_filters( 'apussimpleevent_postype_give_volunteer_labels' , $labels );

		register_post_type( 'give_volunteer',
			array(
				'labels'            => $labels,
				'supports'          => array( 'title', 'editor', 'thumbnail' ),
				'public'            => true,
				'has_archive'       => true,
				'rewrite'           => array( 'slug' => __( 'volunteer', 'apus-charityheart' ) ),
				'menu_position'     => 51,
				'categories'        => array(),
				'show_in_menu'  	=> true,
			)
		);
	}
	/**
	 *
	 */
	public static function metaboxes( array $metaboxes ) {
		$prefix = APUSSIMPLEEVENT_EVENT_PREFIX;
		
		$metaboxes[ $prefix . 'volunteer_info' ] = array(
			'id'                        => $prefix . 'volunteer_info',
			'title'                     => __( 'Volunteer Information', 'apus-charityheart' ),
			'object_types'              => array( 'give_volunteer' ),
			'context'                   => 'normal',
			'priority'                  => 'high',
			'show_names'                => true,
			'fields'                    => self::metaboxes_info_fields()
		);
		
		$metaboxes[ $prefix . 'social' ] = array(
			'id'                        => $prefix . 'social',
			'title'                     => __( 'Social Information', 'apus-charityheart' ),
			'object_types'              => array( 'give_volunteer' ),
			'context'                   => 'normal',
			'priority'                  => 'high',
			'show_names'                => true,
			'fields'                    => self::metaboxes_social_fields()
		);

		return $metaboxes;
	}
	/**
	 *
	 */	
	public static function metaboxes_info_fields() {
		$prefix = APUSCHARITYHEART_PREFIX;

		$fields = array(
			array(
			    'name' => __( 'Address', 'apus-charityheart' ),
			    'id' => $prefix.'address',
			    'type' => 'text'
			),
			array(
			    'name' => __( 'Job', 'apus-charityheart' ),
			    'id'   => $prefix.'job',
			    'type' => 'text'
			),
			array(
			    'name' => __( 'Email', 'apus-charityheart' ),
			    'id'   => $prefix.'email',
			    'type' => 'text'
			),
			array(
			    'name' => __( 'Phone', 'apus-charityheart' ),
			    'id' => $prefix.'phone',
			    'type' => 'text'
			),
			array(
			    'name' => __( 'Skype', 'apus-charityheart' ),
			    'id' => $prefix.'skype',
			    'type' => 'text'
			),
			array(
			    'name' => __( 'Website', 'apus-charityheart' ),
			    'id' => $prefix.'website',
			    'type' => 'text'
			),
		);
		
		return apply_filters( 'apuscharityheart_postype_volunteer_info_metaboxes_fields_management' , $fields );
	}
	/**
	 *
	 */	
	public static function metaboxes_social_fields() {
		$prefix = APUSCHARITYHEART_PREFIX;

		$fields = array(
			array(
			    'name' => __( 'Facebook', 'apus-charityheart' ),
			    'id' => $prefix.'facebook',
			    'type' => 'text'
			),
			array(
			    'name' => __( 'Twitter', 'apus-charityheart' ),
			    'id'   => $prefix.'twitter',
			    'type' => 'text'
			),
			array(
			    'name' => __( 'Google Plus', 'apus-charityheart' ),
			    'id'   => $prefix.'googleplus',
			    'type' => 'text'
			),
			array(
			    'name' => __( 'LinkedIn', 'apus-charityheart' ),
			    'id'   => $prefix.'linkedin',
			    'type' => 'text'
			),
			array(
			    'name' => __( 'Instagram', 'apus-charityheart' ),
			    'id' => $prefix.'instagram',
			    'type' => 'text'
			),
			array(
			    'name' => __( 'Pinterest', 'apus-charityheart' ),
			    'id' => $prefix.'pinterest',
			    'type' => 'text'
			),
		);
		
		return apply_filters( 'apuscharityheart_postype_volunteer_social_metaboxes_fields_management' , $fields );
	}
}

ApusCharityheart_PostType_Give_Volunteer::init();