<?php
/**
 * widget base for apus framework
 *
 * @package    apus-framework
 * @author     Team Apusthemes <apusthemes@gmail.com >
 * @license    GNU General Public License, version 3
 * @copyright  2015-2016 Apus Framework
 */

abstract class Charityheart_Apus_Widget extends WP_Widget {
	
	public $template;
	abstract function getTemplate();

	public function display( $args, $instance ) {
		$this->getTemplate();
		extract($args);
		extract($instance);
		echo $before_widget;
			//require get_template_directory().'/widgets/'.$this->template;
			require $this->locate( $this->template );
		echo $after_widget;
	}

	public function locate( $name, $plugin_dir = APUSCHARITYHEART_PLUGIN_DIR ) {
		$template = '';
		
		// Child theme
		if ( ! $template && ! empty( $name ) && file_exists( get_stylesheet_directory() . "/widgets/{$name}" ) ) {
			$template = get_stylesheet_directory() . "/widgets/{$name}";
		}

		// Original theme
		if ( ! $template && ! empty( $name ) && file_exists( get_template_directory() . "/widgets/{$name}" ) ) {
			$template = get_template_directory() . "/widgets/{$name}";
		}

		// Plugin
		if ( ! $template && ! empty( $name ) && file_exists( $plugin_dir . "/templates/widgets/{$name}" ) ) {
			$template = $plugin_dir . "/templates/widgets/{$name}";
		}

		// Nothing found
		if ( empty( $template ) ) {
			throw new Exception( "Template /templates/widgets/{$name} in plugin dir {$plugin_dir} not found." );
		}

		return $template;
	}
}