<?php
/**
 * Categories
 *
 * @package    apus-charityheart
 * @author     ApusTheme <apusthemes@gmail.com >
 * @license    GNU General Public License, version 3
 * @copyright  13/06/2016 ApusTheme
 */
 
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
class ApusCharityheart_Taxonomy_Volunteer_Categories{

	/**
	 *
	 */
	public static function init() {
		add_action( 'init', array( __CLASS__, 'definition' ) );
	}

	/**
	 *
	 */
	public static function definition() {
		$labels = array(
			'name'              => __( 'Categories', 'apus-charityheart' ),
			'singular_name'     => __( 'Category', 'apus-charityheart' ),
			'search_items'      => __( 'Search Categories', 'apus-charityheart' ),
			'all_items'         => __( 'All Categories', 'apus-charityheart' ),
			'parent_item'       => __( 'Parent Category', 'apus-charityheart' ),
			'parent_item_colon' => __( 'Parent Category:', 'apus-charityheart' ),
			'edit_item'         => __( 'Edit', 'apus-charityheart' ),
			'update_item'       => __( 'Update', 'apus-charityheart' ),
			'add_new_item'      => __( 'Add New', 'apus-charityheart' ),
			'new_item_name'     => __( 'New Category', 'apus-charityheart' ),
			'menu_name'         => __( 'Categories', 'apus-charityheart' ),
		);

		register_taxonomy( 'give_volunteer_category', 'give_volunteer', array(
			'labels'            => apply_filters( 'apuscharityheart_taxomony_volunteer_category_labels', $labels ),
			'hierarchical'      => true,
			'query_var'         => 'give-category',
			'rewrite'           => array( 'slug' => __( 'volunteer-category', 'apus-charityheart' ) ),
			'public'            => true,
			'show_ui'           => true,
		) );
	}
}

ApusCharityheart_Taxonomy_Volunteer_Categories::init();