<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

get_header(); ?>

<section id="primary" class="content-area">
	<main id="main" class="site-main content container" role="main">
		<?php if ( have_posts() ) : ?>
			<?php while ( have_posts() ) : the_post(); ?>
				<?php
					$post_id = get_the_ID();
					$facebook = get_post_meta( $post_id, APUSCHARITYHEART_PREFIX . 'facebook', true );
					$twitter = get_post_meta( $post_id, APUSCHARITYHEART_PREFIX . 'twitter', true );
					$googleplus = get_post_meta( $post_id, APUSCHARITYHEART_PREFIX . 'googleplus', true );
					$linkedin = get_post_meta( $post_id, APUSCHARITYHEART_PREFIX . 'linkedin', true );
					$instagram = get_post_meta( $post_id, APUSCHARITYHEART_PREFIX . 'instagram', true );
					$pinterest = get_post_meta( $post_id, APUSCHARITYHEART_PREFIX . 'pinterest', true );

					$address = get_post_meta( $post_id, APUSCHARITYHEART_PREFIX . 'address', true );
					$job = get_post_meta( $post_id, APUSCHARITYHEART_PREFIX . 'job', true );
					$email = get_post_meta( $post_id, APUSCHARITYHEART_PREFIX . 'email', true );
					$phone = get_post_meta( $post_id, APUSCHARITYHEART_PREFIX . 'phone', true );
					$skype = get_post_meta( $post_id, APUSCHARITYHEART_PREFIX . 'skype', true );
					$website = get_post_meta( $post_id, APUSCHARITYHEART_PREFIX . 'website', true );
				?>
				<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
					<div class="row">
						<div class="col-sm-3">
							<div class="post-thumbnail">
								<?php the_post_thumbnail(); ?>
							</div>

							<?php if ($facebook || $twitter || $googleplus || $linkedin || $instagram || $pinterest) { ?>
								<div class="socials">
									<?php if ($facebook) { ?>
										<a class="facebook" href="<?php echo esc_url($facebook); ?>" title="<?php echo esc_html__( 'Facebook', 'apus-charityheart' ); ?>"><i class=""></i></a>
									<?php } ?>
									<?php if ($twitter) { ?>
										<a class="twitter" href="<?php echo esc_url($twitter); ?>" title="<?php echo esc_html__( 'Twitter', 'apus-charityheart' ); ?>"><i class=""></i></a>
									<?php } ?>
									<?php if ($googleplus) { ?>
										<a class="googleplus" href="<?php echo esc_url($googleplus); ?>" title="<?php echo esc_html__( 'Google Plus', 'apus-charityheart' ); ?>"><i class=""></i></a>
									<?php } ?>
									<?php if ($linkedin) { ?>
										<a class="linkedin" href="<?php echo esc_url($linkedin); ?>" title="<?php echo esc_html__( 'LinkedIn', 'apus-charityheart' ); ?>"><i class=""></i></a>
									<?php } ?>
									<?php if ($instagram) { ?>
										<a class="instagram" href="<?php echo esc_url($instagram); ?>" title="<?php echo esc_html__( 'Instagram', 'apus-charityheart' ); ?>"><i class=""></i></a>
									<?php } ?>
									<?php if ($pinterest) { ?>
										<a class="pinterest" href="<?php echo esc_url($pinterest); ?>" title="<?php echo esc_html__( 'Pinterest', 'apus-charityheart' ); ?>"><i class=""></i></a>
									<?php } ?>
								</div>
							<?php } ?>

							<?php if ($email || $phone || $skype || $website || $address) { ?>
								<ul class="volunteer-information">
									<?php if ($email) { ?>
										<li><i class=""></i> <span><?php echo trim($email); ?></span></li>
									<?php } ?>
									<?php if ($phone) { ?>
										<li><i class=""></i> <span><?php echo trim($phone); ?></span></li>
									<?php } ?>
									<?php if ($skype) { ?>
										<li><i class=""></i> <span><?php echo trim($skype); ?></span></li>
									<?php } ?>
									<?php if ($website) { ?>
										<li><i class=""></i> <span><?php echo trim($website); ?></span></li>
									<?php } ?>
									<?php if ($address) { ?>
										<li><i class=""></i> <span><?php echo trim($address); ?></span></li>
									<?php } ?>
								</ul>
							<?php } ?>
						</div>
						<div class="col-sm-9">
							<?php the_title( '<h3 class="entry-title">', '</h3>' ); ?>
							<?php if ( $job ) { ?>
								<span class="job"><?php echo trim($job); ?></span>
							<?php } ?>
							<div class="entry-content"><?php the_content(); ?></div>
						</div>
					</div>
					<?php echo ApusCharityheart_Template_Loader::get_template_part( 'volunteer-releated' ); ?>
				</article>
			<?php endwhile; ?>

			<?php the_posts_pagination( array(
				'prev_text'          => __( 'Previous page', 'apus-charityheart' ),
				'next_text'          => __( 'Next page', 'apus-charityheart' ),
				'before_page_number' => '<span class="meta-nav screen-reader-text">' . __( 'Page', 'apus-charityheart' ) . ' </span>',
			) ); ?>
		<?php else : ?>
			<?php get_template_part( 'content', 'none' ); ?>
		<?php endif; ?>

	</main>
</section>

<?php get_footer(); ?>
