<?php
/**
 * The template for displaying search results pages.
 *
 * @package WordPress
 * @subpackage Charityheart
 * @since Charityheart 1.0
 */

get_header();

if ( defined('CHARITYHEART_GIVE_ACTIVED') && isset($_GET['post_type']) && $_GET['post_type'] == 'give_forms' ) {
	get_template_part( 'archive', 'give_forms' );
} else {

	$sidebar_configs = charityheart_get_blog_layout_configs();

	$columns = charityheart_get_config('blog_columns', 1);
	$bscol = floor( 12 / $columns );
	$_count  = 0;

	charityheart_render_breadcrumbs();
?>
	<section id="main-container" class="main-content  <?php echo apply_filters('charityheart_blog_content_class', 'container');?> inner">
		<div class="row">
			<?php if ( isset($sidebar_configs['left']) ) : ?>
				<div class="<?php echo esc_attr($sidebar_configs['left']['class']) ;?>">
				  	<aside class="sidebar sidebar-left" itemscope="itemscope" itemtype="http://schema.org/WPSideBar">
				   		<?php if ( is_active_sidebar( $sidebar_configs['left']['sidebar'] ) ): ?>
					   		<?php dynamic_sidebar( $sidebar_configs['left']['sidebar'] ); ?>
					   	<?php endif; ?>
				  	</aside>
				</div>
			<?php endif; ?>

			<div id="main-content" class="col-sm-12 <?php echo esc_attr($sidebar_configs['main']['class']); ?>">
				<main id="main" class="site-main layout-blog" role="main">

				<?php if ( have_posts() ) : ?>

					<header class="page-header hidden">
						<?php
							the_archive_title( '<h1 class="page-title">', '</h1>' );
							the_archive_description( '<div class="taxonomy-description">', '</div>' );
						?>
					</header><!-- .page-header -->

					<?php
					// Start the Loop.
					while ( have_posts() ) : the_post();

						/*
						 * Include the Post-Format-specific template for the content.
						 * If you want to override this in a child theme, then include a file
						 * called content-___.php (where ___ is the Post Format name) and that will be used instead.
						 */
						?>
						<?php if($_count%$columns==0): ?>
							<div class="row">
						<?php endif;?>
							<div class="col-sm-<?php echo esc_attr($bscol); ?>">
								<?php get_template_part( 'post-formats/content', get_post_format() ); ?>
							</div>
						<?php if($_count%$columns==$columns-1 || $_count == $wp_query->post_count -1): ?>
							</div>
						<?php endif; ?>
						<?php
						$_count++;
					// End the loop.
					endwhile;

					// Previous/next page navigation.
					charityheart_paging_nav();

				// If no content, include the "No posts found" template.
				else :
					get_template_part( 'post-formats/content', 'none' );

				endif;
				?>

				</main><!-- .site-main -->
			</div><!-- .content-area -->
			<?php if ( isset($sidebar_configs['right']) ) : ?>
				<div class="<?php echo esc_attr($sidebar_configs['right']['class']) ;?>">
				  	<aside class="sidebar sidebar-right" itemscope="itemscope" itemtype="http://schema.org/WPSideBar">
				   		<?php if ( is_active_sidebar( $sidebar_configs['right']['sidebar'] ) ): ?>
					   		<?php dynamic_sidebar( $sidebar_configs['right']['sidebar'] ); ?>
					   	<?php endif; ?>
				  	</aside>
				</div>
			<?php endif; ?>
			
		</div>
	</section>
<?php
	get_footer();
}
?>
